CREATE TABLE AB18A05T00
(
	T05_ID_PLANTILLA_VALID 		NUMBER(5)  		NOT NULL ,
	T05_COD_PLANTILLA_VALID		VARCHAR2(50)  		NOT NULL ,
	T05_RUTA_PLANTILLA_VALID	VARCHAR2(200)       NOT NULL,
	T06_ID_BOLETIN	 			NUMBER(5) 	 		NOT NULL ,
	T05_FECHA_BAJA	    		DATE		 		NULL,
	T05_PLANTILLA_VALID    		CLOB		 		NULL
)
	TABLESPACE AB18A01E00   
	LOB (T05_PLANTILLA_VALID) STORE AS AB18A05SL00  ( 
	TABLESPACE AB18A01E00
	DISABLE STORAGE IN ROW
	NOCACHE LOGGING);


COMMENT ON TABLE AB18A05T00 IS 'PLANTILLAS XSLT. Tabla para almacenar las plantillas XSLT de validaciones lógicas de los boletines.';


COMMENT ON COLUMN AB18A05T00.T05_ID_PLANTILLA_VALID IS 'Identificativo del registro de la tabla.';

COMMENT ON COLUMN AB18A05T00.T05_COD_PLANTILLA_VALID IS 'Código identificativo de la plantilla.';

COMMENT ON COLUMN AB18A05T00.T05_RUTA_PLANTILLA_VALID IS 'Ruta relativa de la plantilla.';

COMMENT ON COLUMN AB18A05T00.T06_ID_BOLETIN IS 'Identificador del boletín sobre el que aplica la validación.';

COMMENT ON COLUMN AB18A05T00.T05_FECHA_BAJA IS 'Fecha de baja lógica del fichero XSLT.';

COMMENT ON COLUMN AB18A05T00.T05_PLANTILLA_VALID IS 'Fichero físico de la plantilla XSLT.';

ALTER TABLE AB18A05T00
	ADD (CONSTRAINT  PK_AB18A05T00 PRIMARY KEY (T05_ID_PLANTILLA_VALID)
	USING INDEX
  TABLESPACE AB18A02E00);
  COMMIT;

